<?php
namespace Aura\Html\Helper;

/**
 * Test class for Scripts.
 * Generated by PHPUnit on 2011-04-02 at 08:29:01.
 */
class ScriptsTest extends AbstractHelperTest
{
    public function test__invoke()
    {
        $scripts = $this->helper;
        $actual = $scripts();
        $this->assertInstanceOf('Aura\Html\Helper\Scripts', $actual);

        $actual = $scripts('script.js')->__toString();
        $expect = '    <script src="script.js" type="text/javascript"></script>' . PHP_EOL;
        $this->assertSame($expect, $actual);
    }

    public function test()
    {
        $scripts = $this->helper;
        $scripts->setIndent('    ');

        $scripts->add('/js/last.js', 150);
        $scripts->add('/js/first.js', 50);
        $scripts->add('/js/attr.js', 100, array('foo' => true, 'bar' => 'baz', 'bing' => 'true'));
        $scripts->add('/js/middle.js');
        $scripts->addCond('ie6', '/js/ie6.js');

        $actual = $scripts->__toString();

        $expect = '    <script src="/js/first.js" type="text/javascript"></script>' . PHP_EOL
                . '    <script foo bar="baz" bing="true" src="/js/attr.js" type="text/javascript"></script>'. PHP_EOL
                . '    <script src="/js/middle.js" type="text/javascript"></script>' . PHP_EOL
                . '    <!--[if ie6]><script src="/js/ie6.js" type="text/javascript"></script><![endif]-->' . PHP_EOL
                . '    <script src="/js/last.js" type="text/javascript"></script>' . PHP_EOL;

        $this->assertSame($expect, $actual);
    }

    public function testInternal()
    {
        $scripts = $this->helper;
        $scripts->addInternal('alert("foo");');
        $scripts->addCondInternal('ie6', 'alert("ie6");');

        $scripts->beginInternal();
        echo 'alert("captured");';
        $scripts->endInternal();

        $scripts->beginCondInternal('ie6');
        echo 'alert("captured ie6");';
        $scripts->endInternal();


        $actual = $scripts->__toString();

        $expect = '    <script type="text/javascript">alert("foo");</script>' . PHP_EOL
            . '    <!--[if ie6]><script type="text/javascript">alert("ie6");</script><![endif]-->' . PHP_EOL
            . '    <script type="text/javascript">alert("captured");</script>' . PHP_EOL
            . '    <!--[if ie6]><script type="text/javascript">alert("captured ie6");</script><![endif]-->' . PHP_EOL;


        $this->assertSame($expect, $actual);
    }
}
